<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * HOVER EFFECT settings for Grid Layout elements
 */

return array(
	'breakpoint_1_width' => array(
		'title' => __( 'Below screen width', 'us' ),
		'type' => 'slider',
		'options' => array(
			'px' => array(
				'min' => 900,
				'max' => 1500,
			),
		),
		'std' => ( (int) us_get_option( 'laptops_breakpoint' ) + 1 ) . 'px',
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_1_cols' => array(
		'title' => us_translate( 'Columns' ),
		'type' => 'select',
		'options' => array(
			'default' => '– ' . __( 'As on Desktops', 'us' ) . ' –',
			'10' => '10',
			'9' => '9',
			'8' => '8',
			'7' => '7',
			'6' => '6',
			'5' => '5',
			'4' => '4',
			'3' => '3',
			'2' => '2',
			'1' => '1',
		),
		'std' => 'default',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_1_quantity' => array(
		'title' => __( 'Quantity', 'us' ),
		'description' => __( 'Leave blank to use the value from main settings.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'pagination', '=', 'none' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_1_gap' => array(
		'title' => __( 'Gap between Items', 'us' ),
		'description' => __( 'Leave blank to use the value from the larger screen width.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),

	'breakpoint_2_width' => array(
		'title' => __( 'Below screen width', 'us' ),
		'type' => 'slider',
		'options' => array(
			'px' => array(
				'min' => 600,
				'max' => 1200,
			),
		),
		'std' => ( (int) us_get_option( 'tablets_breakpoint' ) + 1 ) . 'px',
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_2_cols' => array(
		'title' => us_translate( 'Columns' ),
		'type' => 'select',
		'options' => array(
			'default' => '– ' . __( 'As on Laptops', 'us' ) . ' –',
			'10' => '10',
			'9' => '9',
			'8' => '8',
			'7' => '7',
			'6' => '6',
			'5' => '5',
			'4' => '4',
			'3' => '3',
			'2' => '2',
			'1' => '1',
		),
		'std' => '2',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_2_quantity' => array(
		'title' => __( 'Quantity', 'us' ),
		'description' => __( 'Leave blank to use the value from main settings.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'pagination', '=', 'none' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_2_gap' => array(
		'title' => __( 'Gap between Items', 'us' ),
		'description' => __( 'Leave blank to use the value from the larger screen width.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),

	'breakpoint_3_width' => array(
		'title' => __( 'Below screen width', 'us' ),
		'type' => 'slider',
		'options' => array(
			'px' => array(
				'min' => 300,
				'max' => 900,
			),
		),
		'std' => ( (int) us_get_option( 'mobiles_breakpoint' ) + 1 ) . 'px',
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_3_cols' => array(
		'title' => us_translate( 'Columns' ),
		'type' => 'select',
		'options' => array(
			'10' => '10',
			'9' => '9',
			'8' => '8',
			'7' => '7',
			'6' => '6',
			'5' => '5',
			'4' => '4',
			'3' => '3',
			'2' => '2',
			'1' => '1',
		),
		'std' => '1',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_3_quantity' => array(
		'title' => __( 'Quantity', 'us' ),
		'description' => __( 'Leave blank to use the value from main settings.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'pagination', '=', 'none' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
	'breakpoint_3_gap' => array(
		'title' => __( 'Gap between Items', 'us' ),
		'description' => __( 'Leave blank to use the value from the larger screen width.', 'us' ),
		'type' => 'text',
		'std' => '',
		'cols' => 3,
		'show_if' => array( 'type', '!=', 'metro' ),
		'exclude_for_carousel' => TRUE,
		'group' => __( 'Responsive', 'us' ),
		'usb_preview' => TRUE,
	),
);
